library(memisc)
library(magrittr)
rm(list=ls())
load("ESS-cumul-1-10.RData")

ESS.1.1 <- within(ESS.1,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "CZ" -> vote.czechia,
        cntry == "GR" -> vote.greece,
        cntry == "HU" -> vote.hungary,
        cntry == "IL" -> vote.israel,
        cntry == "LU" -> vote.luxembourg,
        cntry == "PL" -> vote.poland,
        cntry == "SI" -> vote.slovenia,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LV" -> 35,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- regionde == "Bayern"
    brussels <- regionbe == "Brussels region"
    flanders <- regionbe == "Flemish region"
    scotland <- regiongb == "Scotland"
    wales    <- regiongb == "Wales"
    catalunia <- regiones == "Cataluña"
    basque <- regiones == "País Vasco" | regiones == "Comunidad Foral de Navarra"
})

ESS.2.1 <- within(ESS.2,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "GR" -> vote.greece,
        cntry == "IS" -> vote.iceland,
        cntry == "LU" -> vote.luxembourg,
        cntry == "PL" -> vote.poland,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "TR" -> vote.turkey,
        cntry == "UA" -> vote.ukraine,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- regionde == "Bayern"
    brussels <- regionbe == "Brussels region"
    flanders <- regionbe == "Flemish region"
    scotland <- regiongb == "Scotland"
    wales    <- regiongb == "Wales"
    catalunia <- regiones == "Cataluña"
    basque <- regiones == "País Vasco" | regiones == "Comunidad Foral de Navarra"
})

ESS.3.1 <- within(ESS.3,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CY" -> vote.cyprus,
        cntry == "EE" -> vote.estonia,
        cntry == "HU" -> vote.hungary,
        cntry == "LV" -> vote.latvia,
        cntry == "PL" -> vote.poland,
        cntry == "RU" -> vote.russia,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "UA" -> vote.ukraine,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- regionde == "Bayern"
    brussels <- regionbe == "Brussels region"
    flanders <- regionbe == "Flemish region"
    scotland <- regiongb == "Scotland"
    wales    <- regiongb == "Wales"
    n.irland <- regiongb == "Northern Ireland"
    catalunia <- regioaes == "Cataluña"
    basque <- regioaes == "País Vasco" | regioaes == "Comunidad Foral de Navarra"
})

ESS.4.1 <- within(ESS.4,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CY" -> vote.cyprus,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "GR" -> vote.greece,
        cntry == "HR" -> vote.croatia,
        cntry == "HU" -> vote.hungary,
        cntry == "IL" -> vote.israel,
        cntry == "LT" -> vote.lithuania1,
        cntry == "LV" -> vote.latvia,
        cntry == "PL" -> vote.poland,
        cntry == "RO" -> vote.romania,
        cntry == "RU" -> vote.russia,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "TR" -> vote.turkey,
        cntry == "UA" -> vote.ukraine,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- regionde == "Bayern"
    brussels <- regionbe == "Brussels region"
    flanders <- regionbe == "Flemish region"
    scotland <- regiongb == "Scotland"
    wales    <- regiongb == "Wales"
    catalunia <- regioaes == "Cataluña"
    basque <- regioaes == "País Vasco" | regioaes == "Comunidad Foral de Navarra"
})

ESS.5.1 <- within(ESS.5,{
    vote <- cases(
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CY" -> vote.cyprus,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "GR" -> vote.greece,
        cntry == "HR" -> vote.croatia,
        cntry == "HU" -> vote.hungary,
        cntry == "IL" -> vote.israel,
        cntry == "LT" -> vote.lithuania1,
        cntry == "PL" -> vote.poland,
        cntry == "RU" -> vote.russia,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "UA" -> vote.ukraine,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})

ESS.6.1 <- within(ESS.6,{
    vote.austria <- NA
    vote <- cases(
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "AL" -> vote.albania,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CY" -> vote.cyprus,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "HU" -> vote.hungary,
        cntry == "IL" -> vote.israel,
        cntry == "LT" -> vote.lithuania1,
        cntry == "PL" -> vote.poland,
        cntry == "RU" -> vote.russia,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "UA" -> vote.ukraine,
        cntry == "XK" -> vote.kosovo,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})

ESS.7.1 <- within(ESS.7,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "HU" -> vote.hungary,
        cntry == "IL" -> vote.israel,
        cntry == "LT" -> vote.lithuania1,
        cntry == "PL" -> vote.poland,
        cntry == "SI" -> vote.slovenia,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})

ESS.8.1 <- within(ESS.8,{
    vote.denmark <- NA
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GB" -> vote.uk,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "HU" -> vote.hungary,
        cntry == "IS" -> vote.iceland,
        cntry == "IL" -> vote.israel,
        cntry == "LT" -> vote.lithuania1,
        cntry == "PL" -> vote.poland,
        cntry == "RU" -> vote.russia,
        cntry == "SI" -> vote.slovenia,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})

ESS.9.1 <- within(ESS.9,{
    vote <- cases(
        cntry == "AT" -> vote.austria,
        cntry == "BE" -> vote.belgium,
        cntry == "CH" -> vote.switzerland,
        cntry == "DE" -> vote.germany,
        cntry == "DK" -> vote.denmark,
        cntry == "ES" -> vote.spain,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "HU" -> vote.hungary,
        cntry == "IS" -> vote.iceland,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "GB" -> vote.uk,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SE" -> vote.sweden,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CY" -> vote.cyprus,
        cntry == "CZ" -> vote.czechia,
        cntry == "EE" -> vote.estonia,
        cntry == "HR" -> vote.croatia,
        cntry == "LV" -> vote.latvia,
        cntry == "LT" -> vote.lithuania1,
        cntry == "ME" -> vote.montenegro,
        cntry == "PL" -> vote.poland,
        cntry == "RS" -> vote.serbia,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    labels(region) <- labels(region) + c("Centro.pt"="PT16")
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})

ESS.10.1 <- within(ESS.10,{
    vote <- cases(
        cntry == "BE" -> vote.belgium,
        cntry == "BG" -> vote.bulgaria,
        cntry == "CH" -> vote.switzerland,
        cntry == "HR" -> vote.croatia,
        cntry == "EE" -> vote.estonia,
        cntry == "FI" -> vote.finland,
        cntry == "FR" -> vote.france,
        cntry == "GR" -> vote.greece,
        cntry == "HU" -> vote.hungary,
        cntry == "IS" -> vote.iceland,
        cntry == "IE" -> vote.ireland,
        cntry == "IT" -> vote.italy,
        cntry == "LT" -> vote.lithuania1,
        cntry == "ME" -> vote.montenegro,
        cntry == "NL" -> vote.netherla,
        cntry == "NO" -> vote.norway,
        cntry == "PT" -> vote.portugal,
        cntry == "SI" -> vote.slovenia,
        cntry == "SK" -> vote.slovakia,
        cntry == "GB" -> vote.uk,
        TRUE -> NA
    )
    country <- recode(cntry,
                      "AT" -> 1,
                      "BE" -> 2,
                      "CH" -> 3,
                      "DE" -> 5,
                      "DK" -> 6,
                      "ES" -> 7,
                      "FI" -> 8,
                      "FR" -> 9,
                      "GB" -> 10,
                      "IE" -> 13,
                      "IT" -> 15,
                      "NL" -> 17,
                      "NO" -> 18,
                      "PT" -> 20,
                      "SE" -> 21,
                      "ME" -> 40,
                      "RS" -> 41,
                      "AL" -> 38,
                      "BG" -> 28,
                      "HR" -> 33,
                      "CY" -> 29,
                      "CZ" -> 4,
                      "EE" -> 23,
                      "GR" -> 11,
                      "HU" -> 12,
                      "IS" -> 24,
                      "XK" -> 39,
                      "LT" -> 35,
                      "LV" -> 30,
                      "LU" -> 16,
                      "PL" -> 19,
                      "RO" -> 31,
                      "RU" -> 32,
                      "SK" -> 25,
                      "SI" -> 22,
                      "TR" -> 26,
                      "UA" -> 27 
                      )
    region <- deduplicate_labels(region)
    labels(region) <- labels(region) + c("Centro.pt"="PT16")
    country <- as.integer(country)
    vote <- ifelse(vote < 66,
                   country*100 + vote,
                   vote*100)
    bavaria  <- as.factor(region) == "Bayern"
    bavaria[cntry!="DE"] <- NA
    brussels <- as.character(region,use.labels=FALSE) == "BE10"
    flanders <- as.character(region,use.labels=FALSE) %in% c("BE21","BE22","BE23","BE24","BE25")
    brussels[cntry!="BE"] <- NA
    flanders[cntry!="BE"] <- NA
    scotland  <- as.factor(region) == "Scotland"
    wales     <- as.factor(region) == "Wales"
    n.irland  <- as.factor(region) == "Northern Ireland"
    scotland[cntry!="GB"] <- NA
    wales[cntry!="GB"] <- NA
    n.irland[cntry!="GB"] <- NA
    catalunia <- as.factor(region) == "Cataluña"
    basque    <- as.factor(region) == "País Vasco" | as.factor(region) == "Comunidad Foral de Navarra"
    catalunia[cntry!="ES"] <- NA
    basque[cntry!="ES"] <- NA
})



foreach(E=c(
    ESS.1.1,
    ESS.2.1,
    ESS.3.1,
    ESS.4.1,
    ESS.5.1,
    ESS.6.1,
    ESS.7.1,
    ESS.8.1,
    ESS.9.1,
    ESS.10.1
    ),
{
    votenames <- grep("vote.",names(E),fixed=TRUE,value=TRUE)
    for(v in votenames){
        E[[v]] <- NULL
    }
})

ESS.CHES.partycodes <- read.csv("ESS-CHES-partycodes.csv",row.names=1)

library(magrittr)

ESS.CHES.partycodes %<>% subset(
                             select=c(
                                 essround,
                                 vote,
                                 year,
                                 CHES_id
                             ))

ESS.CHES.partycodes %<>% rename(year="CHES_year")

ESS.CHES.partycodes <- unique(ESS.CHES.partycodes)

foreach(E=c(
    ESS.1.1,
    ESS.2.1,
    ESS.3.1,
    ESS.4.1,
    ESS.5.1,
    ESS.6.1,
    ESS.7.1,
    ESS.8.1,
    ESS.9.1,
    ESS.10.1
    ),
{
    E$id <- 1:nrow(E)
    E <- merge(E,ESS.CHES.partycodes,all.x=TRUE)
    uq <- !duplicated(E$id)
    E <- E[uq,]
    ii <- order(E$id)
    E <- E[ii,]
    rm(ii)
})



foreach(E1=c(
    ESS.1.1,
    ESS.2.1,
    ESS.3.1,
    ESS.4.1,
    ESS.5.1,
    ESS.6.1,
    ESS.7.1,
    ESS.8.1,
    ESS.9.1,
    ESS.10.1
    ),E=c(
    ESS.1,
    ESS.2,
    ESS.3,
    ESS.4,
    ESS.5,
    ESS.6,
    ESS.7,
    ESS.8,
    ESS.9,
    ESS.10
    ),
{
    print(nrow(E1)==nrow(E))
})



save(
    ESS.1.1,
    ESS.2.1,
    ESS.3.1,
    ESS.4.1,
    ESS.5.1,
    ESS.6.1,
    ESS.7.1,
    ESS.8.1,
    ESS.9.1,
    ESS.10.1,
    file="ESS-cumul-1-10-a.RData")

